/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.dialog;

import filenet.vw.api.VWSession;
import filenet.vw.base.VWUDDIRegistryList;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.ws.VWUDDIExplorerPanel;
import filenet.vw.toolkit.utils.ws.VWWSWorkflowExplorerPanel;
import filenet.vw.toolkit.utils.ws.wsrr.VWWSRRExplorerPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public final class VWWebServicesExplorerDialog
extends VWModalDialog
implements ActionListener,
ItemListener {
    VWSession m_session = null;
    VWUDDIRegistryList m_vwRegistryList = null;
    private JPanel m_mainPanel = null;
    private boolean m_bNewInstance = true;
    private JPanel m_selectionPanel = null;
    private JRadioButton m_localWSDLRadioBtn = null;
    private JRadioButton m_uddiWSDLRadioBtn = null;
    private JRadioButton m_wsrrRadioBtn = null;
    private VWUDDIExplorerPanel m_uddiExplorerPanel = null;
    private VWWSWorkflowExplorerPanel m_localWSDLExplorerPanel = null;
    VWWSRRExplorerPanel m_wsrrExplorerPanel = null;
    private JPanel m_buttonPanel = null;
    private JButton m_okBtn = null;
    private JButton m_cancelBtn = null;
    private JButton m_helpBtn = null;
    private String m_highlitedWSDL = null;
    private String m_selectedWSDL = null;
    private String m_initialWSDL = null;
    private boolean m_bCancel = false;
    protected ItemListener m_selectListeners = null;

    public VWWebServicesExplorerDialog(Frame parent, VWSession session, String initialWSDL) {
        super(parent);
        this.m_session = session;
        this.m_initialWSDL = initialWSDL;
        this.m_selectedWSDL = initialWSDL;
        this.setupLayout();
    }

    public VWWebServicesExplorerDialog(Frame parent, VWUDDIRegistryList vwRegistryList, String initialWSDL) {
        super(parent);
        this.m_vwRegistryList = vwRegistryList;
        this.m_initialWSDL = initialWSDL;
        this.m_selectedWSDL = initialWSDL;
        this.setupLayout();
    }

    public VWWebServicesExplorerDialog(Dialog parent, VWSession session, String initialWSDL) {
        super(parent);
        this.m_session = session;
        this.m_initialWSDL = initialWSDL;
        this.m_selectedWSDL = initialWSDL;
        this.setupLayout();
    }

    public VWWebServicesExplorerDialog(Dialog parent, VWUDDIRegistryList vwRegistryList, String initialWSDL) {
        super(parent);
        this.m_vwRegistryList = vwRegistryList;
        this.m_initialWSDL = initialWSDL;
        this.m_selectedWSDL = initialWSDL;
        this.setupLayout();
    }

    protected void setupLayout() {
        Container contentPane = this.getContentPane();
        this.setResizable(true);
        Dimension dim = null;
        dim = VWStringUtils.stringToDimension("715, 445");
        if (dim == null) {
            dim = new Dimension(650, 400);
        }
        this.setSize(dim.width, dim.height);
        this.setVisible(false);
        this.setTitle(VWResource.s_webServicesExplorerDialogTitle);
        this.m_mainPanel = new JPanel();
        this.m_mainPanel.setLayout(new BorderLayout(10, 10));
        this.m_selectionPanel = new JPanel();
        this.m_selectionPanel.setLayout(new BoxLayout(this.m_selectionPanel, 2));
        JLabel exploreLabel = new JLabel(VWResource.s_label.toString(VWResource.s_explore));
        ButtonGroup grp = new ButtonGroup();
        this.m_localWSDLRadioBtn = new JRadioButton(VWResource.s_webServicesWorkflows);
        this.m_uddiWSDLRadioBtn = new JRadioButton(VWResource.s_uddiRegistries);
        this.m_wsrrRadioBtn = new JRadioButton(VWResource.s_wsrrRegistries);
        grp.add(this.m_wsrrRadioBtn);
        grp.add(this.m_uddiWSDLRadioBtn);
        grp.add(this.m_localWSDLRadioBtn);
        this.m_wsrrRadioBtn.setSelected(true);
        this.m_uddiWSDLRadioBtn.setSelected(false);
        this.m_localWSDLRadioBtn.setSelected(false);
        this.m_selectionPanel.add(exploreLabel);
        this.m_selectionPanel.add(this.m_wsrrRadioBtn);
        this.m_selectionPanel.add(this.m_uddiWSDLRadioBtn);
        this.m_selectionPanel.add(this.m_localWSDLRadioBtn);
        this.m_selectionPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 0, 0));
        this.m_wsrrRadioBtn.addItemListener(this);
        this.m_uddiWSDLRadioBtn.addItemListener(this);
        this.m_localWSDLRadioBtn.addItemListener(this);
        this.m_uddiExplorerPanel = this.m_session != null ? new VWUDDIExplorerPanel((Dialog)this, this.m_session) : new VWUDDIExplorerPanel((Dialog)this, this.m_vwRegistryList);
        this.m_uddiExplorerPanel.setVisible(false);
        this.m_localWSDLExplorerPanel = new VWWSWorkflowExplorerPanel(this, this.m_session);
        this.m_localWSDLExplorerPanel.setVisible(false);
        this.m_wsrrExplorerPanel = new VWWSRRExplorerPanel(this, this.m_session);
        this.m_wsrrExplorerPanel.setVisible(true);
        this.m_buttonPanel = new JPanel();
        this.m_buttonPanel.setLayout(new FlowLayout());
        this.m_okBtn = new JButton(VWResource.s_ok);
        this.m_cancelBtn = new JButton(VWResource.s_cancel);
        this.m_helpBtn = new JButton(VWResource.s_help);
        this.m_buttonPanel.add(this.m_okBtn);
        this.m_buttonPanel.add(this.m_cancelBtn);
        this.m_buttonPanel.add(this.m_helpBtn);
        this.m_okBtn.addActionListener(this);
        this.m_cancelBtn.addActionListener(this);
        this.m_helpBtn.addActionListener(this);
        this.m_mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.m_mainPanel.add((Component)this.m_wsrrExplorerPanel, "Center");
        contentPane.add((Component)this.m_selectionPanel, "First");
        contentPane.add((Component)this.m_mainPanel, "Center");
        contentPane.add((Component)this.m_buttonPanel, "Last");
        this.m_localWSDLExplorerPanel.addItemListener(this);
        this.m_uddiExplorerPanel.addItemListener(this);
        this.m_wsrrExplorerPanel.addItemListener(this);
        this.m_okBtn.setEnabled(false);
        ComponentOrientation o = ComponentOrientation.getOrientation(Locale.getDefault());
        contentPane.applyComponentOrientation(o);
    }

    public void addNotify() {
        super.addNotify();
        this.repaint();
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.m_helpBtn) {
            VWHelp.displayPage(VWHelp.Help_Process_Designer + "bpfdh161.htm");
        } else if (source == this.m_okBtn) {
            this.m_selectedWSDL = this.m_highlitedWSDL;
            this.m_bCancel = false;
            this.setVisible(false);
        } else if (source == this.m_cancelBtn) {
            this.m_bCancel = true;
            this.m_selectedWSDL = this.m_initialWSDL;
            this.setVisible(false);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        Object item = null;
        if (source == this.m_uddiExplorerPanel || source == this.m_localWSDLExplorerPanel || source == this.m_wsrrExplorerPanel) {
            item = e.getItem();
        } else if (source == this.m_uddiWSDLRadioBtn) {
            if (e.getStateChange() == 1) {
                item = this.m_uddiExplorerPanel.getSelectedWSDLURL();
                this.m_localWSDLExplorerPanel.setVisible(false);
                this.m_wsrrExplorerPanel.setVisible(false);
                this.m_uddiExplorerPanel.setVisible(true);
                this.m_mainPanel.remove(this.m_localWSDLExplorerPanel);
                this.m_mainPanel.remove(this.m_wsrrExplorerPanel);
                this.m_mainPanel.add((Component)this.m_uddiExplorerPanel, "Center");
            }
        } else if (source == this.m_localWSDLRadioBtn) {
            if (e.getStateChange() == 1) {
                try {
                    item = this.m_localWSDLExplorerPanel.getSelectedWSDLURL();
                }
                catch (Exception ex) {
                    item = null;
                }
                this.m_localWSDLExplorerPanel.setVisible(true);
                this.m_wsrrExplorerPanel.setVisible(false);
                this.m_uddiExplorerPanel.setVisible(false);
                this.m_mainPanel.remove(this.m_uddiExplorerPanel);
                this.m_mainPanel.remove(this.m_wsrrExplorerPanel);
                this.m_mainPanel.add((Component)this.m_localWSDLExplorerPanel, "Center");
            }
        } else if (source == this.m_wsrrRadioBtn && e.getStateChange() == 1) {
            try {
                item = this.m_wsrrExplorerPanel.getSelectedWSDLURL();
            }
            catch (Exception ex) {
                item = null;
            }
            this.m_wsrrExplorerPanel.setVisible(true);
            this.m_localWSDLExplorerPanel.setVisible(false);
            this.m_uddiExplorerPanel.setVisible(false);
            this.m_mainPanel.remove(this.m_uddiExplorerPanel);
            this.m_mainPanel.remove(this.m_localWSDLExplorerPanel);
            this.m_mainPanel.add((Component)this.m_wsrrExplorerPanel, "Center");
        }
        if (item != null && item instanceof String) {
            this.m_okBtn.setEnabled(true);
            this.m_highlitedWSDL = (String)item;
        } else {
            this.m_okBtn.setEnabled(false);
            this.m_highlitedWSDL = null;
        }
    }

    public boolean isCanceled() {
        return this.m_bCancel;
    }

    public String getSelectedWSDL() {
        return this.m_selectedWSDL;
    }

    public void setInitialWSDL(String wsdl) {
        this.m_initialWSDL = wsdl;
        this.m_selectedWSDL = wsdl;
    }
}

